<?php
namespace Webkul\GadzmoneyWallet\ViewModel;

use Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoTransactions;

class HelperViewModel implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var BitcoinCryptoTransactions
     */
    protected $bitcoinCryptoTransactions;

    /**
     * @var \Magento\Sales\Model\OrderFactory
     */
    protected $order;
    
    /**
     * @param BitcoinCryptoTransactions $bitcoinCryptoTransactions
     * @param \Magento\Sales\Model\OrderFactory $order
     */
    public function __construct(
        BitcoinCryptoTransactions $bitcoinCryptoTransactions,
        \Magento\Sales\Model\OrderFactory $order,
    ) {
        $this->bitcoinCryptoTransactions = $bitcoinCryptoTransactions;
        $this->order = $order;
    }

    /**
     * Get Order Details For Crypto
     *
     * @param int $orderId
     * @return \Magento\Sales\Model\Order
     */
    public function getTransactionId($orderId)
    {
        $transactionDetails = $this->bitcoinCryptoTransactions
                    ->getCollection();
        $transaction = $transactionDetails->addFieldToFilter('sales_order_id', $orderId)->getFirstItem();
        if (!$transaction->getId()) {
            return null;
        }
        return $transaction->getTransactionNumber();
    }

    /**
     * Get Order Details For Crypto
     *
     * @param int $orderId
     * @return \Magento\Sales\Model\Order
     */
    public function getOrderDetails($orderId)
    {
        $order = $this->order->create()->load($orderId);
        if (!$order->getId()) {
            return null;
        }
        return $order;
    }
}
