<?php

namespace Webkul\GadzmoneyWallet\Rewrite\Controller\Crypto;

use Magento\Framework\Controller\ResultFactory;
use Magento\Directory\Model\Currency as CurrencyModel;
use Webkul\BitcoinCryptoPayment\Helper\Data as CryptoHelper;
use Webkul\BitcoinCryptoPayment\Model\BitcoinCrypto as PaymentModel;
use Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoPayment as CryptoCollection;

/**
 * Class Request
 * Generate request data to create order and proceed payment
 */
class Request extends \Webkul\BitcoinCryptoPayment\Controller\Crypto\Request
{
    /**
     * @var \Magento\Framework\DataObject
     */
    protected $dataObject;

    /**
     * @var \Webkul\GadzmoneyWallet\Helper\Data
     */
    protected $helper;

    /**
     * Constructor
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param CryptoHelper $cryptoHelper
     * @param CurrencyModel $currencyModel
     * @param PaymentModel $paymentmodel
     * @param CryptoCollection $cryptocollection
     * @param \Magento\Quote\Model\QuoteRepository $quoteRepository
     * @param \Magento\Quote\Model\QuoteIdMaskFactory $quoteIdMaskFactory
     * @param \Magento\Framework\DataObject $dataObject
     * @param \Webkul\GadzmoneyWallet\Helper\Data $helper
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        CryptoHelper $cryptoHelper,
        CurrencyModel $currencyModel,
        PaymentModel $paymentmodel,
        CryptoCollection $cryptocollection,
        \Magento\Quote\Model\QuoteRepository $quoteRepository,
        \Magento\Quote\Model\QuoteIdMaskFactory $quoteIdMaskFactory,
        \Magento\Framework\DataObject $dataObject,
        \Webkul\GadzmoneyWallet\Helper\Data $helper
    ) {
        $this->dataObject = $dataObject;
        $this->helper = $helper;
        parent::__construct(
            $context,
            $cryptoHelper,
            $currencyModel,
            $paymentmodel,
            $cryptocollection,
            $quoteRepository,
            $quoteIdMaskFactory
        );
    }
    
    /**
     * Execute function
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $crypto_id = $this->getRequest()->getParam('crypto_id');
        $quoteid = $this->getRequest()->getParam('quoteid');
        $customerIsLogin = $this->getRequest()->getParam('login');
        $cartId = $quoteid ?? 0;
        $isLogin = $customerIsLogin == 0 ? false : true;
        if (!$isLogin) {
            $quoteIdMask = $this->quoteIdMaskFactory->create()->load($cartId, 'masked_id');
            if ($quoteIdMask->getId()) {
                $cartId = $quoteIdMask->getQuoteId();
            }
        }
        $quote = $this->quoteRepository->get($cartId);
        $quoteItems = $quote->getItems()[0];
        $cartFirstProductId = $quoteItems->getProductId();
        $crypto_currency = $this->getRequest()->getParam('crypto_currency');
        $conversion_rate = $this->getRequest()->getParam('conversion_rate');
        $crypto_amount = $this->getRequest()->getParam('crypto_amount');

        $paymentDetails = $this->cryptocollection->load($crypto_id);
        if ($crypto_id == 0 && $crypto_currency == "Gadzmoney") {
            $paymentDetails = clone $this->dataObject;
            $paymentDetails->setData([
                "entity_id" => "0",
                "name" => "Gadzmoney",
                "unit" => "GADZRT",
                "address" => $this->helper->getAlphWalletAddress($cartFirstProductId),
                "decimal_places" => "2",
                "customer_groups" => "0,1,2,3",
                "currency" => "",
                "carrier" => "",
                "status" => "1",
                "sort_order" => "1",
                "is_tag_required" => "0",
                "destination_tag_memo" => null,
                "created_at" => "",
                "updated_at" => ""
            ]);
        }
        $responseContent = [
            'success' => false,
        ];

        if ($paymentDetails) {

            $currentQuote = $this->cryptoHelper->getCurrentQuote();

            $totalOrderAmt = (float) $currentQuote->getGrandTotal();
            $currencySign = $this->cryptoHelper->getQuoteCurrency();
            $exchangeRate = $this->cryptoHelper->getExchangeRate(
                $totalOrderAmt,
                $currencySign,
                $paymentDetails->getUnit(),
                $paymentDetails->getDecimalPlaces()
            );

            $quote->setData('crypto_currency', $crypto_currency);
            $quote->setData('conversion_rate', $conversion_rate);
            $quote->setData('crypto_payment_method_id', $crypto_id);
            $quote->setData('crypto_amount', $crypto_amount);
            $this->quoteRepository->save($quote);

            $method = $paymentDetails->getData();
            $totalOrderAmt = (float) $currentQuote->getGrandTotal();
            $currencySign = $this->cryptoHelper->getQuoteCurrency();
            $exchangeRate = $this->cryptoHelper->getExchangeRate(
                $totalOrderAmt,
                $currencySign,
                $method['unit'],
                $method['decimal_places']
            );

            $currencyCode = $currentQuote->getQuoteCurrencyCode();
            $currencySymbol = $this->currencyModel->load($currencyCode)->getCurrencySymbol();
            $precision = 2;

            $formattedAmount = $this->currencyModel->format(
                $totalOrderAmt,
                ['symbol' => $currencySymbol, 'precision'=> $precision],
                false,
                false
            );
            $htmlDataArray = ['entity_id' => $method['entity_id'],
                'exchaged_amount' => $exchangeRate,
                'unit' => $method['unit'],
                'isDisplayQrCode' => $this->paymentmodel->isDisplayWalletAddressOrCode(),
                'address' => $method['address'],
                'formattedAmount' => $formattedAmount,
                'iscancelOrder' => $this->paymentmodel->cancelOrder(),
                'cancelDaysNumber' => $this->paymentmodel->cancelOrderTimePeriod(),
                'isShowTag' => $method['is_tag_required'],
                'dTag' => $method['destination_tag_memo'],
            ];

            $responseContent = [
                'success' => true,
                'walletAddress' => $paymentDetails->getAddress(),
                'paymentDetails' => $paymentDetails->getData(),
                'exchangeRate' => $exchangeRate,
                'psOrderTotal' => $formattedAmount,
                'showQR' => (bool) $this->paymentmodel->isDisplayWalletAddressOrCode(),
                'cancel_order_enabled' => (bool) $this->paymentmodel->cancelOrder(),
                'cancel_in_days' => $this->paymentmodel->cancelOrderTimePeriod(),
                'htmlContentArray' => $htmlDataArray,
            ];
        }

        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        $response->setData($responseContent);
        return $response;
    }
}
