<?php

namespace Webkul\GadzmoneyWallet\Rewrite\Controller\Crypto;

class AvailablePaymentMethods extends \Webkul\BitcoinCryptoPayment\Controller\Crypto\AvailablePaymentMethods
{
    /**
     * Get available crypto payment methods
     *
     * @return array
     */
    public function getAvailableCryptoPaymentMethods()
    {
        $paymentDetails = $this->cryptoHelper->getCryptoPaymentMethodsForOrder();
        $totalOrderAmt = (float) $this->cryptoHelper->getCurrentQuote()->getGrandTotal();
        $currencySign = $this->cryptoHelper->getQuoteCurrency();
        if ($paymentDetails != [] && $currencySign != "GADZRT") {
            foreach ($paymentDetails as $k => &$method) {
                $exchangeRate = $this->cryptoHelper->getExchangeRate(
                    $totalOrderAmt,
                    $currencySign,
                    $method['unit'],
                    $method['decimal_places']
                );
                if ($exchangeRate) {
                    $method['exchaged_amount'] = $exchangeRate;
                } else {
                    unset($paymentDetails[$k]);
                }
            }
        } else {
            $paymentDetail[] = [
                "entity_id" => "0",
                "name" => "Gadzmoney",
                "unit" => "GADZRT",
                "address" => "",
                "decimal_places" => "2",
                "customer_groups" => "0,1,2,3",
                "currency" => "",
                "carrier" => "",
                "status" => "1",
                "sort_order" => "1",
                "is_tag_required" => "0",
                "destination_tag_memo" => null,
                "created_at" => "",
                "updated_at" => "",
                "exchaged_amount" => 1 * $totalOrderAmt
            ];
            $paymentDetails = $paymentDetail;
        }
        $updatedArray = array_values($paymentDetails);
        return $updatedArray ?? [];
    }
}
