<?php

namespace Webkul\GadzmoneyWallet\Rewrite\Controller\Account;

/**
 * Webkul Marketplace Account EditprofilePost Controller.
 */
class EditprofilePost extends \Webkul\Marketplace\Controller\Account\EditprofilePost
{
    /**
     * Save Seller Profile Info
     *
     * @param int $sellerId
     * @param int $storeId
     * @param array $fields
     * @return void
     */
    protected function saveSellerProfileInfo($sellerId, $storeId, $fields)
    {
        $autoId = 0;
        $collection = $this->sellerModel->create()
            ->getCollection()
            ->addFieldToFilter('seller_id', $sellerId)
            ->addFieldToFilter('store_id', $storeId);
        foreach ($collection as $value) {
            $autoId = $value->getId();
        }
        $fields['tw_active'] = (!isset($fields['tw_active'])) ? 0 : $fields['tw_active'];
        $fields['fb_active'] = (!isset($fields['fb_active'])) ? 0 : $fields['fb_active'];
        $fields['youtube_active'] = (!isset($fields['youtube_active'])) ? 0 : $fields['youtube_active'];
        $fields['vimeo_active'] = (!isset($fields['vimeo_active'])) ? 0 : $fields['vimeo_active'];
        $fields['instagram_active'] = (!isset($fields['instagram_active'])) ? 0 : $fields['instagram_active'];
        $fields['pinterest_active'] = (!isset($fields['pinterest_active'])) ? 0 : $fields['pinterest_active'];
        $fields['moleskine_active'] = (!isset($fields['moleskine_active'])) ? 0 : $fields['moleskine_active'];
        $fields['tiktok_active'] = (!isset($fields['tiktok_active'])) ? 0 : $fields['tiktok_active'];
        // If seller data doesn't exist for current store
        if (!$autoId) {
            $sellerDefaultData = [];
            $collection = $this->sellerModel->create()
                ->getCollection()
                ->addFieldToFilter('seller_id', $sellerId)
                ->addFieldToFilter('store_id', 0);
            foreach ($collection as $value) {
                $sellerDefaultData = $value->getData();
            }
            foreach ($sellerDefaultData as $key => $value) {
                if (empty($fields[$key]) && $key != 'entity_id') {
                    $fields[$key] = $value;
                }
            }
        }

        // Save seller data for current store
        $value = $this->sellerModel->create()->load($autoId);
        $value->addData($fields);
        if (!$autoId) {
            $value->setCreatedAt($this->_date->gmtDate());
        }

        $value->save();
        if (isset($fields['company_description'])) {
            $fields['company_description'] = $this->escapeString($fields['company_description']);
            $value->setCompanyDescription($fields['company_description']);
        }

        if (isset($fields['return_policy'])) {
            $fields['return_policy'] = $this->escapeString($fields['return_policy']);
            $value->setReturnPolicy($fields['return_policy']);
        }

        if (isset($fields['shipping_policy'])) {
            $fields['shipping_policy'] = $this->escapeString($fields['shipping_policy']);
            $value->setShippingPolicy($fields['shipping_policy']);
        }

        if (isset($fields['privacy_policy'])) {
            $fields['privacy_policy'] = $this->escapeString($fields['privacy_policy']);
            $value->setPrivacyPolicy($fields['privacy_policy']);
        }

        $value->setMetaDescription($fields['meta_description']);

        /**
         * Set taxvat number for seller
         */
        if ($fields['taxvat']) {
            $customer = $this->customerModel->create()->load($sellerId);
            $customer->setTaxvat($fields['taxvat']);
            $customer->setId($sellerId)->save();
        }
        if (!empty($fields['fulfilment_text'])) {
            $value->setFulfilmentText($fields['fulfilment_text']);
        }
        if (!empty($fields['alph_wallet_addr'])) {
            $value->setAlphWalletAddress($fields['alph_wallet_addr']);
        }
        // perform action on seller's images
        $target = $this->_mediaDirectory->getAbsolutePath('avatar/');
        $canfulfilmentDelete = $canBannerPicDelete = $canLogoPicDelete = "";
        if ($value->getFulfilmentImage() && $this->canPicDelete($value->getId(), $value->getFulfilmentImage())) {
            $canfulfilmentDelete = $value->getFulfilmentImage();
        }
        if ($value->getBannerPic() && $this->canPicDelete($value->getId(), $value->getBannerPic())) {
            $canBannerPicDelete = $value->getBannerPic();
        }
        if ($value->getLogoPic() && $this->canPicDelete($value->getId(), $value->getLogoPic())) {
            $canLogoPicDelete = $value->getLogoPic();
        }
        try {

            $uploader = $this->_fileUploaderFactory->create(
                ['fileId' => 'fulfilment_image']
            );
            $uploader->setAllowedExtensions(['jpg', 'jpeg', 'gif', 'png']);
            $uploader->setAllowRenameFiles(true);
            $result = $uploader->save($target);
            if ($result['file']) {
                $value->setFulfilmentImage($result['file']);
            }
        } catch (\Exception $e) {
            $canfulfilmentDelete = "";
            $this->helper->logDataInLogger(
                "Controller_Account_EditProfilePost execute : " . $e->getMessage()
            );
            if ($e->getMessage() != 'The file was not uploaded.') {
                $this->messageManager->addError($e->getMessage());
                $this->dataPersistor->set('seller_profile_data', $fields);
            }
        }
        try {

            $uploader = $this->_fileUploaderFactory->create(
                ['fileId' => 'banner_pic']
            );
            $uploader->setAllowedExtensions(['jpg', 'jpeg', 'gif', 'png']);
            $uploader->setAllowRenameFiles(true);
            $result = $uploader->save($target);
            if ($result['file']) {
                $value->setBannerPic($result['file']);
            }
        } catch (\Exception $e) {
            $canBannerPicDelete = "";
            $this->helper->logDataInLogger(
                "Controller_Account_EditProfilePost execute : " . $e->getMessage()
            );
            if ($e->getMessage() != 'The file was not uploaded.') {
                $this->messageManager->addError($e->getMessage());
                $this->dataPersistor->set('seller_profile_data', $fields);
            }
        }
        try {
            $uploaderLogo = $this->_fileUploaderFactory->create(
                ['fileId' => 'logo_pic']
            );
            $uploaderLogo->setAllowedExtensions(['jpg', 'jpeg', 'png']);
            $uploaderLogo->setAllowRenameFiles(true);
            $resultLogo = $uploaderLogo->save($target);
            if ($resultLogo['file']) {
                $value->setLogoPic($resultLogo['file']);
            }
        } catch (\Exception $e) {
            $canLogoPicDelete = "";
            $this->helper->logDataInLogger(
                "Controller_Account_EditProfilePost execute : " . $e->getMessage()
            );
            if ($e->getMessage() != 'The file was not uploaded.') {
                $this->messageManager->addError($e->getMessage());
                $this->dataPersistor->set('seller_profile_data', $fields);
            }
        }
        $driverFile = $this->helper->getDriverFile();
        if ($canfulfilmentDelete) {
            if ($driverFile->isExists($target . $canfulfilmentDelete)) {
                $driverFile->deleteFile($target . $canfulfilmentDelete);
            }
        }
        if ($canBannerPicDelete) {
            if ($driverFile->isExists($target . $canBannerPicDelete)) {
                $driverFile->deleteFile($target . $canBannerPicDelete);
            }
        }
        if ($canLogoPicDelete) {
            if ($driverFile->isExists($target . $canLogoPicDelete)) {
                $driverFile->deleteFile($target . $canLogoPicDelete);
            }
        }
        // End of perform action on seller's images
        if (array_key_exists('country_pic', $fields)) {
            $value->setCountryPic($fields['country_pic']);
        }
        $value->save();
        if (array_key_exists('country_pic', $fields)) {
            $value->setCountryPic($fields['country_pic']);
        }
        $value->setStoreId($storeId);
        $value->save();
        $sellerData = $value;
        $this->saveInOtherStores($value->getId(), $sellerData);
        try {
            // clear cache
            $this->helper->clearCache();

            $this->messageManager->addSuccess(
                __('Profile information was successfully saved')
            );
            $this->dataPersistor->clear('seller_profile_data');

            return $this->resultRedirectFactory->create()->setPath(
                '*/*/editProfile',
                ['_secure' => $this->getRequest()->isSecure()]
            );
        } catch (\Exception $e) {
            $this->helper->logDataInLogger(
                "Controller_Account_EditProfilePost execute : " . $e->getMessage()
            );
            $this->messageManager->addException($e, __('We can\'t save the customer.'));
        }
    }
}
