<?php

namespace Magento\Framework\Locale\Bundle;

class CurrencyBundle extends DataBundle
{
    /**
     * @var string
     */
    protected $path = 'ICUDATA-curr';

    /**
     * @var string
     */
    public function toArray($bundle)
    {
        $aux = [];
        foreach ($bundle as $k => $v) {
            $aux[$k] = is_object($v) ? $this->toArray($v) : $v;
        }
        return $aux;
    }

    /**
     * Method to get currency bundle
     *
     * @param string $locale
     * @return array
     */
    public function get($locale)
    {
        $bundle = parent::get($locale);
        $bundleAsArray = $this->toArray($bundle);
        $bundleAsArray['Currencies']['GADZRT'] = [
            'GADZRT',
            'Gadzmoney',
        ];
        $bundleAsArray['CurrencyPlurals']['GADZRT'] = [
            'one' => 'Gadzmoney',
            'other' => 'Gadzmoney',
        ];
        return $bundleAsArray;
    }
}