<?php

namespace Webkul\GadzmoneyWallet\Observer;

use Magento\Framework\Event\ObserverInterface;
use Webkul\Marketplace\Model\Orders;
use Magento\Sales\Model\Order;

/**
 * Webkul Marketplace SalesOrderPlaceAfterObserver Observer Model.
 */
class SalesOrderPlaceAfterObserver implements ObserverInterface
{
    /**
     * @var Orders
     */
    protected $mporder;

    /**
     * @var Order
     */
    protected $order;

    /**
     * Construct
     *
     * @param Orders $mporder
     */
    public function __construct(
        Orders $mporder,
        Order $order
    ) {
        $this->mporder = $mporder;
        $this->order = $order;
    }

    /**
     * Sales Order Place After event handler.
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $orderId = $observer->getOrder()->getId();
        $order = $this->order->load($orderId);
        if (in_array($order->getStatus(), ["awaiting_for_crypto_payment","verifying_crypto_payment"])) {
            $collectionSales = $this->mporder->getCollection()
                ->addFieldToFilter('order_id', ['eq' => $orderId]);
            $collectionSales->getFirstItem()->setOrderStatus($order->getStatus());
            $collectionSales->save();
        }
    }
}
