<?php

namespace Webkul\GadzmoneyWallet\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Event\Observer;
use Magento\Checkout\Model\Cart;
use Magento\Framework\Message\ManagerInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Webkul\Marketplace\Model\Product as MpProduct; // Assuming you use Webkul

class RestrictMultipleSellerProducts implements ObserverInterface
{
    protected $cart;
    protected $messageManager;
    protected $productRepository;
    protected $mpProduct;
    protected $responseFactory;
    protected $url;
    
    public function __construct(
        Cart $cart,
        ManagerInterface $messageManager,
        ProductRepositoryInterface $productRepository,
        \Magento\Framework\App\ResponseFactory $responseFactory,
        \Magento\Framework\UrlInterface $url,
        MpProduct $mpProduct
    ) {
        $this->cart = $cart;
        $this->messageManager = $messageManager;
        $this->productRepository = $productRepository;
        $this->responseFactory = $responseFactory;
        $this->url = $url;
        $this->mpProduct = $mpProduct;
    }    

    public function execute(Observer $observer)
    {
        $product = $observer->getEvent()->getProduct();
        $newSellerId = $this->getSellerIdByProductId($product->getId());

        if (!$newSellerId) {
            return;
        }

        $quote = $this->cart->getQuote();
        $items = $quote->getAllVisibleItems();
        $message = "";
        foreach ($items as $item) {
            $itemProductId = $item->getProduct()->getId();
            $existingSellerId = $this->getSellerIdByProductId($itemProductId);

            if (
                ($existingSellerId == 'admin' && $newSellerId != 'admin')
                || ($existingSellerId != 'admin' && $newSellerId == 'admin')
            ) {
                $message = ($existingSellerId == 'admin')
                    ? __('Your cart contains admin products. Please complete or empty your cart before adding products from a seller.')
                    : __('Your cart contains products from a seller. Please complete or empty your cart before adding admin products.');
            } elseif ($existingSellerId != $newSellerId) {
                $message = __('You can only add products from one seller at a time. Please complete or empty your cart before adding items from a different seller.');
            }
            if ($message != "") {
                $this->messageManager->addErrorMessage($message);
                $this->responseFactory->create()->setRedirect(
                    $this->url->getUrl('*/*/*', ['_current' => true])
                )->sendResponse();
                exit;
            }
        }
    }


    private function getSellerIdByProductId($productId)
    {
        $marketplaceProduct = $this->mpProduct->getCollection()
            ->addFieldToFilter('mageproduct_id', $productId)
            ->getFirstItem();
        if ($marketplaceProduct && $marketplaceProduct->getId()) {
            return $marketplaceProduct->getSellerId(); // Seller product
        }

        return 'admin';
    }
}
