<?php

namespace Webkul\GadzmoneyWallet\Model;

use Webkul\GadzmoneyWallet\Api\Data\SellerInterface;

class Seller extends \Webkul\Marketplace\Model\Seller
{
    /**
     * Set Alephium Wallet Address
     *
     * @param string $alphwalletaddress
     * 
     * @return Webkul\Marketplace\Model\SellerInterface
     */
    public function setAlphWalletAddress($alphwalletaddress)
    {
        return $this->setData(SellerInterface::ALPH_WALLET_ADDRESS, $alphwalletaddress);
    }

    /**
     * Get Alephium Wallet Address
     *
     * @return string
     */
    public function getAlphWalletAddress()
    {
        return parent::getData(SellerInterface::ALPH_WALLET_ADDRESS);
    }
}
