<?php

namespace Webkul\GadzmoneyWallet\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\StoreManagerInterface;

class Data extends AbstractHelper
{
    protected const Admin_Alepium_Wallet_Address = 'webkul/gadzmoney/alph_wallet_address';

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Webkul\Marketplace\Model\ResourceModel\Seller\Collection
     */
    protected $sellerCollection;

    /**
     * @var \Webkul\Marketplace\Model\ResourceModel\Product\Collection
     */
    protected $mpsellerProducts;

    /**
     * @var StoreManagerInterface
     */
    protected $storeManager;

    /**
     * Construct
     *
     * @param Context $context
     * @param ScopeConfigInterface $scopeConfig
     * @param \Webkul\Marketplace\Model\ResourceModel\Seller\Collection $sellerCollection
     * @param \Webkul\Marketplace\Model\ResourceModel\Product\Collection $sellerCollection
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Context $context,
        ScopeConfigInterface $scopeConfig,
        \Webkul\Marketplace\Model\ResourceModel\Seller\Collection $sellerCollection,
        \Webkul\Marketplace\Model\ResourceModel\Product\Collection $mpsellerProducts,
        StoreManagerInterface $storeManager
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->sellerCollection = $sellerCollection;
        $this->mpsellerProducts = $mpsellerProducts;
        $this->storeManager = $storeManager;
        parent::__construct($context);
    }

    /**
     * get Alephium Wallet Address by Product Id
     *
     * @param int $productId
     * 
     * @return string
     */
    public function getAlphWalletAddress($productId) {
        $sellerProduct = $this->mpsellerProducts
        ->addFieldToFilter('mageproduct_id', ['eq' => $productId])
        ->getFirstItem();
        if (!empty($sellerProduct->getEntityId())) {
            $sellerId = $sellerProduct->getSellerId();
            $sellerAlphWalletAddr = $this->sellerCollection
                ->addFieldToFilter('seller_id', ['eq' => $sellerId])
                ->addFieldToFilter('store_id', ['eq' => $this->storeManager->getStore()->getId()])
                ->getFirstItem()
                ->getAlphWalletAddress();
            return $sellerAlphWalletAddr;
        } else {
            $adminAlphWalletAddr = $this->scopeConfig->getValue(
                self::Admin_Alepium_Wallet_Address,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            );
            return $adminAlphWalletAddr;
        }
    }
}
