/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

define([
  "Magento_Checkout/js/view/payment/default",
  "Magento_Checkout/js/model/quote",
  "jquery",
  "Magento_Checkout/js/model/payment/additional-validators",
  "mage/url",
  "Magento_Customer/js/model/customer",
  "underscore",
  "Magento_Checkout/js/model/full-screen-loader",
  "Magento_Ui/js/modal/modal",
  "Magento_Checkout/js/action/redirect-on-success",
  "ko",
  "wkQrCode",
], function (
  Component,
  quote,
  $,
  additionalValidators,
  url,
  customer,
  _,
  fullScreenLoader,
  modal,
  redirectOnSuccessAction,
  ko
) {
  "use strict";

  return Component.extend({
    modalWindow: null,
    listType: window.checkoutConfig.payment.bitcoincryptopayment.listType,
    paymentTemplate:
      window.checkoutConfig.payment.bitcoincryptopayment.paymentTemplate,
    wkShowQR: window.checkoutConfig.payment.bitcoincryptopayment.wkShowQR,
    htmlContentArray:
      window.checkoutConfig.payment.bitcoincryptopayment.paymentTemplate,
    sortedMethods:
      window.checkoutConfig.payment.bitcoincryptopayment.sortedMethods,
    defaults: {
      template: "Webkul_BitcoinCryptoPayment/payment/bitcoincryptopayment",
    },
    contentData: ko.observable([]),
    availablePaymentMethods: ko.observable([]),
    enablePlaceOrder: ko.observable(false),
    errorPaymentMsg: ko.observable(false),

    initialize: function () {
      this._super();
      var self = this;
      quote.totals.subscribe(function () {
        fullScreenLoader.startLoader();
        $.ajax({
          type: "POST",
          url: url.build("cryptopayments/crypto/availablepaymentmethods"),
          data: {
            isAjax: true,
          },
          /**
           * Success callback
           * @param {Object} response
           */
          success: function (response) {
            fullScreenLoader.stopLoader();
            if (response.success) {
              self.availablePaymentMethods(response.availablePaymentMethods);
              if (response.availablePaymentMethods.length != 0) {
                self.enablePlaceOrder(true);
              }
            } else if (response.count == 0) {
              self.errorPaymentMsg(true);
            }
          },
          /**
           * Error callback
           * @param {*} response
           */
          error: function (response) {
            fullScreenLoader.stopLoader();
          },
        });
      });
    },

    /**
     * Place order.
     */
    placeOrder: function (data, event) {
      var self = this;
      var paymentCryptoId = $(
        ".crypto-payment-details._show .id_cryptopayment"
      ).val();
      if (event) {
        event.preventDefault();
      }
      if (!paymentCryptoId) {
        this.getCryptoPaymentsModal();
        return;
      }

      if (
        this.validate() &&
        additionalValidators.validate() &&
        this.isPlaceOrderActionAllowed() === true
      ) {
        this.isPlaceOrderActionAllowed(false);

        this.getPlaceOrderDeferredObject()
          .done(function () {
            self.afterPlaceOrder();

            if (self.redirectAfterPlaceOrder) {
              redirectOnSuccessAction.execute();
            }
          })
          .always(function () {
            self.isPlaceOrderActionAllowed(true);
          });

        return true;
      }
      return false;
    },

    getCryptoPaymentsModal: function () {
      var self = this;
      fullScreenLoader.startLoader();
      $.ajax({
        type: "POST",
        url: url.build("cryptopayments/crypto/request"),
        data: {
          isAjax: true,
          crypto_id: $(".checkedradio").val(),
          quoteid: quote.getQuoteId(),
          login: customer.customerData.id ? 1 : 0,
          crypto_currency: self.getCryptoCurrencyName($(".checkedradio").val()),
          conversion_rate: self.getCryptoCurrencyRate($(".checkedradio").val()),
          crypto_amount: self.getExchangedAmount($(".checkedradio").val()),
        },
        /**
         * Success callback
         * @param {Object} response
         */
        success: function (response) {
          fullScreenLoader.stopLoader();
          if (response.success) {
            self.contentData({
              entity_id: response.htmlContentArray.entity_id,
              exchaged_amount: response.htmlContentArray.exchaged_amount,
              isDisplayQrCode: response.htmlContentArray.isDisplayQrCode,
              address: response.htmlContentArray.address,
              formattedAmount: response.htmlContentArray.formattedAmount,
              iscancelOrder: response.htmlContentArray.iscancelOrder,
              cancelDaysNumber: response.htmlContentArray.cancelDaysNumber,
              unit: response.htmlContentArray.unit,
              isShowTag: response.htmlContentArray.isShowTag,
              dTag: response.htmlContentArray.dTag,
            });
            $("#wkCryptQrCode_" + response.paymentDetails.entity_id).html("");
            self.createPopUp(response.paymentDetails);
            if (self.wkShowQR == 1) {
              self.createQRImage(response.paymentDetails);
            }
            self.showModal();
          }
        },

        /**
         * Error callback
         * @param {*} response
         */
        error: function (response) {
          fullScreenLoader.stopLoader();
        },
      });
    },

    onClickCrypto: function (event) {
      if ($(event.currentTarget).attr("type") == "radio") {
        $(document).find(".wk-flat-listing").removeClass("active");
        $(event.currentTarget).parents(".wk-flat-listing").addClass("active");
        $(document).find(".wk-flat-listing input").removeClass("checkedradio");
        $(event.currentTarget).addClass("checkedradio");
      }
    },

    createPopUp: function (paymentDetails) {
      this.modalWindow = $(
        "#opc_crypto_currency_display_" + paymentDetails.entity_id
      );
      var options = {
        type: "popup",
        title:
          '<span class="sbi sbi-' +
          paymentDetails.unit.toLowerCase() +
          '"></span> Pay with ' +
          paymentDetails.name,
        modalClass: "crypto-payment-details",
        responsive: true,
        innerScroll: true,
        clickableOverlay: false,
        buttons: [],
      };
      modal(options, $(this.modalWindow));
    },

    showModal: function () {
      $(this.modalWindow).modal("openModal");
    },

    createQRImage: function (paymentDetails) {
      if (this.wkShowQR) {
        $("#wkCryptQrCode_" + paymentDetails.entity_id).qrcode({
          width: 200,
          height: 200,
          useSVG: false,
          text: paymentDetails.address,
        });
        $("#wkCryptQrCode_" + paymentDetails.entity_id + " > canvas").attr(
          "alt",
          paymentDetails.address
        );
      }
    },

    proceedPayment: function () {
      fullScreenLoader.startLoader();
      $(".checkout-original-key").trigger("click");
    },

    getCryptoCurrencyName: function (cryptoId) {
      var refMethod = this.sortedMethods[cryptoId] ?? [];

      // check if we have an updated amount, if yes then will return that amount
      let selectedCrypto = this.availablePaymentMethods().filter(
        (cryptoCurrency) => cryptoCurrency.entity_id == cryptoId
      );
      if (typeof selectedCrypto[0].name !== "undefined") {
        return selectedCrypto[0].name;
      }
      return refMethod.name;
    },

    getCryptoCurrencyRate: function (cryptoId) {
      var refMethod = this.sortedMethods[cryptoId] ?? [];

      // check if we have an updated amount, if yes then will return that amount
      let selectedCrypto = this.availablePaymentMethods().filter(
        (cryptoCurrency) => cryptoCurrency.entity_id == cryptoId
      );
      if (typeof selectedCrypto[0].exchaged_amount !== "undefined") {
        return selectedCrypto[0].exchaged_amount;
      }
      return refMethod.exchaged_amount;
    },

    getExchangedAmount: function (cryptoId) {
      var refMethod = this.sortedMethods[cryptoId] ?? [];

      // check if we have an updated amount, if yes then will return that amount
      let selectedCrypto = this.availablePaymentMethods().filter(
        (cryptoCurrency) => cryptoCurrency.entity_id == cryptoId
      );
      if (typeof selectedCrypto[0].exchaged_amount !== "undefined") {
        return selectedCrypto[0].exchaged_amount;
      }
      return refMethod.exchaged_amount;
    },

    onChangeCrypto: function (obj, event) {
      $(document)
        .find(".wkcryptopayment-lisings select option")
        .removeClass("checkedradio");
      $(event.currentTarget).addClass("checkedradio");
    },
  });
});
