/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
define([
  "jquery",
  "mage/translate",
  "jquery/ui",
  "wkQrCode",
  "wkClipBoardJs",
], function ($, $t) {
  $.widget("mage.qrImageCode", {
    /**
     * Widget initialization
     * @private
     */
    _create: function () {
      $("#wkCryptQrCode").qrcode({
        width: 200,
        height: 200,
        useSVG: false,
        text: this.options.wallet_address,
      });
      $("#wkCryptQrCode > canvas").attr("alt", this.options.wallet_address);

      let clipboardWkBitcoin = new ClipboardJS(
        "[data-clipboard-wkbitcoinpayment]"
      );
      clipboardWkBitcoin.on("success", function (e) {
        e.clearSelection();
      });

      $(document).on("click", ".submit-transaction", function () {
        $(this).attr("disabled", "disabled");
        $("#wk-errors").html("");
        $("#wk-errors").hide();
        let idCryptoOrder = Number($("#id_cryptopayment_order").val());
        let idCryptoTxn = $("#wk_transaction_number").val();
        if (idCryptoOrder && idCryptoTxn) {
          $.ajax({
            url: $("#urlTransaction").val(),
            type: "post",
            dataType: "json",
            beforeSend: function () {
              $("body").trigger("processStart");
            },
            complete: function () {
              $("body").trigger("processStop");
            },
            data: { idCryptoOrder: idCryptoOrder, idCryptoTxn: idCryptoTxn },
            success: function (result) {
              $("body").trigger("processStop");
              if (result.success) {
                $("#wk-success").html(result.message);
                $("#wk-success").show();
                setTimeout(() => {
                  window.location.reload();
                }, 2000);
              } else {
                $("#wk-errors").html(result.message);
                $("#wk-errors").show();
                $("#wk_confirmPayment").removeAttr("disabled");
              }
            },
            error: function (xhr) {
              $("body").trigger("processStop");
              $(".wk_btc_loader").hide();
              $("#wk_confirmPayment").removeAttr("disabled");
              alert(xhr.statusText + xhr.responseText);
            },
          });
        } else {
          $("body").trigger("processStop");
          let msg = $t("Enter the transaction hash.");
          $("#wk-errors").html(msg);
          $("#wk-errors").show();
          $(this).removeAttr("disabled");
        }
      });
    },
  });

  return $.mage.qrImageCode;
});
