/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

define([
    'underscore',
    'uiRegistry',
    'Magento_Ui/js/form/element/single-checkbox',
    'Magento_Ui/js/modal/modal',
    'ko'
], function (_, uiRegistry, select, modal, ko) {
    'use strict';
    return select.extend({
        initialize: function () {
            this._super();
            this.fieldDepend(this.value());
            return this;
        },
        onUpdate: function (value) {
            var field_destination_tag_memo = uiRegistry.get('index = destination_tag_memo');
            if (value == 0) {
                field_destination_tag_memo.hide();
            } else {
                field_destination_tag_memo.show();
            }
            return this._super();
        },
        fieldDepend: function (value) {
            setTimeout(function () {
                var field_destination_tag_memo = uiRegistry.get('index = destination_tag_memo');
                if (value == 0) {
                    field_destination_tag_memo.hide();
                } else {
                    field_destination_tag_memo.show();
                }
            });
        }
    });
});