/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

require([
  "Magento_Ui/js/lib/validation/validator",
  "jquery",
  "wallet-address-validate",
], function (validator, $, waddressValidate) {
  validator.addRule(
    "crypto-unit-validate",
    function (unit) {
      if (waddressValidate.findCurrency(unit.toLowerCase())) {
        return true;
      } else {
        return false;
      }
    },
    $.mage.__("Wallet unit does not exists.")
  );
});
