/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

require([
  "Magento_Ui/js/lib/validation/validator",
  "jquery"
], function (validator, $) {
  validator.addRule(
    "crypto-unit-special-chars-validate",
    function (unit) {
      if (/^[a-zA-Z]+$/.test(unit)) {
        return true;
      } else {
        return false;
      }
    },
    $.mage.__("Wallet unit should not consist special characters.")
  );
});


