/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

require([
  "Magento_Ui/js/lib/validation/validator",
  "jquery",
  "wallet-address-validate",
], function (validator, $, waddressValidate) {
  validator.addRule(
    "crypto-address-validate",
    function (waddressval) {
      try {
        if (
          waddressValidate.validate(waddressval, $("input[name=unit]").val())
        ) {
          return true;
        } else {
          return false;
        }
      } catch (err) {
        return false;
      }
    },
    $.mage.__("Invalid wallet address.")
  );
});
