<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Observer;

class InvoicePayAfter implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * Execute function
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $order = $observer->getInvoice()->getOrder();
        if ($order instanceof \Magento\Framework\Model\AbstractModel) {
            if ($order->getState() == 'awaiting_for_crypto_payment' ||
                $order->getState() == 'verifying_crypto_payment') {
                $order->setState('processing');
                $order->setStatus('processing');
                $order->save();
            }
        }
    }
}
