<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Model\ResourceModel\BitcoinCryptoTransactions;

use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

/**
 * BitcoinCryptoTransactions Resource Model Collection
 */
class Collection extends AbstractCollection
{
    /**
     * @var string
     */
    protected $_idFieldName = 'entity_id';

    /**
     *
     * @var string
     */
    protected $eventPrefix = 'webkul_bitcoin_crypto_payments_transactions';

    /**
     *
     * @var string
     */
    protected $eventObject = 'webkul_bitcoin_crypto_payments_transactions';

    /**
     * Initialize resource collection
     *
     * @return void
     */
    public function _construct()
    {
        $this->_init(
            \Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoTransactions::class,
            \Webkul\BitcoinCryptoPayment\Model\ResourceModel\BitcoinCryptoTransactions::class
        );
    }
}
