<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Model\Grid;

use Webkul\BitcoinCryptoPayment\Model\ResourceModel\BitcoinCryptoPayment\CollectionFactory;

class DataProvider extends \Magento\Ui\DataProvider\AbstractDataProvider
{
    /**
     * @var array
     */
    protected $_loadedData;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @var \Magento\Framework\UrlInterface
     */
    public $url;

    /**
     * Constructor
     *
     * @param string $name
     * @param string $primaryFieldName
     * @param string $requestFieldName
     * @param CollectionFactory $collectionFactory
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Framework\UrlInterface $url
     * @param array $meta
     * @param array $data
     */
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $collectionFactory,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\UrlInterface $url,
        array $meta = [],
        array $data = []
    ) {
        $this->collection = $collectionFactory->create();
        $this->storeManager = $storeManager;
        $this->url = $url;
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
    }

    /**
     * Get Data
     *
     * @return array
     */
    public function getData()
    {
        if (isset($this->_loadedData)) {
            return $this->_loadedData;
        }

        $items = $this->collection->getItems();
        foreach ($items as $record) {
            $allData = $record->getData();
            if (isset($allData['customer_groups']) && $allData['customer_groups'] != '') {
                $allData['data']['customer_groups'] = explode(',', $allData['customer_groups']);
            }
            if (isset($allData['currency']) && $allData['currency'] != '') {
                $allData['data']['currency'] = explode(',', $allData['currency']);
            }

            if (isset($allData['carrier']) && $allData['carrier'] != '') {
                $allData['data']['carrier'] = explode(',', $allData['carrier']);
            }
            if (isset($allData['sort_order']) && $allData['sort_order'] != '') {
                $allData['data']['sort_order'] = $allData['sort_order'];
            }
            $this->_loadedData[$record->getEntityId()] = $allData;
        }
        return $this->_loadedData;
    }
}
