<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Model\Config\Source;

use Magento\Framework\App\RequestInterface;
use Magento\Framework\Data\OptionSourceInterface;
use Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoPaymentFactory;

class Position implements OptionSourceInterface
{
    /**
     * Payment factory
     *
     * @var BitcoinCryptoPaymentFactory
     */
    protected $bitcoinCryptoPaymentFactory;

    /**
     * Request Interface
     *
     * @var RequestInterface
     */
    protected $request;

    /**
     * Constructor
     *
     * @param BitcoinCryptoPaymentFactory $bitcoinCryptoPaymentFactory
     * @param RequestInterface $request
     */
    public function __construct(
        BitcoinCryptoPaymentFactory $bitcoinCryptoPaymentFactory,
        RequestInterface $request
    ) {
        $this->bitcoinCryptoPaymentFactory = $bitcoinCryptoPaymentFactory;
        $this->request = $request;
    }

    /**
     * Option Array
     *
     * @return array
     */
    public function toOptionArray()
    {
        $sort_orderArray = $this->bitcoinCryptoPaymentFactory->create()->getCollection()
            ->addFieldToSelect('sort_order')
            ->getColumnValues('sort_order');
        $entityId = $this->request->getParam('entity_id');
        $sortData = $this->bitcoinCryptoPaymentFactory->create()->load($entityId);
        if ($entityId && $sortData->getSortOrder() != '') {
            if (($key = array_search($sortData->getSortOrder(), $sort_orderArray)) !== false) {
                unset($sort_orderArray[$key]);
            }
        }
        $range = range(1, 10);
        $rangeOptions = [];
        foreach ($range as $key => $number) {
            if (in_array($number, $sort_orderArray)) {
                continue;
            }
            $rangeArray = ['label' => $number, 'value' => $number];
            $rangeOptions[] = $rangeArray;
        }
        return $rangeOptions;
    }
}
