<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Model\Config\Source;

use Magento\Customer\Model\ResourceModel\Group\Collection as CustomerGroup;
use Magento\Framework\Data\OptionSourceInterface;

class CustomerGroupsOptions implements OptionSourceInterface
{
    /**
     * @var CustomerGroup
     */
    protected $customerGroup;

    /**
     * Constructor
     *
     * @param CustomerGroup $customerGroup
     */
    public function __construct(
        CustomerGroup $customerGroup
    ) {
        $this->customerGroup = $customerGroup;
    }

    /**
     * Option Array
     *
     * @return array
     */
    public function toOptionArray()
    {
        $customerGroups = $this->customerGroup->toOptionArray();
        return $customerGroups;
    }
}
