<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class CurrencyOptions implements OptionSourceInterface
{
    /**
     * Currency
     *
     * @var \Magento\Directory\Model\Currency
     */
    protected $currencyModel;

    /**
     * Constructor
     *
     * @param \Magento\Directory\Model\Currency $currencyModel
     */
    public function __construct(
        \Magento\Directory\Model\Currency $currencyModel
    ) {
        $this->currencyModel = $currencyModel;
    }

    /**
     * Option Array
     *
     * @return array
     */
    public function toOptionArray()
    {
        $currencyAllowed = $this->currencyModel->getConfigAllowCurrencies();
        $currencyOptions = [];
        foreach ($currencyAllowed as $key => $currency) {
            $currencyArray = ['label' => $currency, 'value' => $currency];
            $currencyOptions[] = $currencyArray;
        }
        return $currencyOptions;
    }
}
