<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Model;

use Webkul\BitcoinCryptoPayment\Api\Data\BitcoinCryptoPaymentInterface;

class BitcoinCryptoPayment extends \Magento\Framework\Model\AbstractModel implements BitcoinCryptoPaymentInterface
{
    /**
     * CMS page cache tag.
     */
    public const CACHE_TAG = 'webkul_bitcoin_crypto_payments';

    /**
     * @var string
     */
    protected $_cacheTag = 'webkul_bitcoin_crypto_payments';

    /**
     * Prefix of model events names.
     *
     * @var string
     */
    protected $_eventPrefix = 'webkul_bitcoin_crypto_payments';

    /**
     * Initialize resource model.
     */
    protected function _construct()
    {
        $this->_init(\Webkul\BitcoinCryptoPayment\Model\ResourceModel\BitcoinCryptoPayment::class);
    }

    /**
     * Get EntityId.
     *
     * @return int
     */
    public function getEntityId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * Set EntityId.
     *
     * @param int $entityId
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * Get Name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->getData(self::NAME);
    }

    /**
     * Set Name.
     *
     * @param string $name
     */
    public function setName($name)
    {
        return $this->setData(self::NAME, $name);
    }

    /**
     * Get Unit.
     *
     * @return string
     */
    public function getUnit()
    {
        return $this->getData(self::UNIT);
    }

    /**
     * Set Unit.
     *
     * @param string $unit
     */
    public function setUnit($unit)
    {
        return $this->setData(self::UNIT, $unit);
    }

    /**
     * Get Address.
     *
     * @return string
     */
    public function getAddress()
    {
        return $this->getData(self::ADDRESS);
    }

    /**
     * Set Address.
     *
     * @param string $address
     */
    public function setAddress($address)
    {
        return $this->setData(self::ADDRESS, $address);
    }

    /**
     * Get Decimal Places.
     *
     * @return int
     */
    public function getDecimalPlaces()
    {
        return $this->getData(self::DECIMAL_PLACES);
    }

    /**
     * Set Decimal Places.
     *
     * @param int $decimalPlaces
     */
    public function setDecimalPlaces($decimalPlaces)
    {
        return $this->setData(self::DECIMAL_PLACES, $decimalPlaces);
    }

    /**
     * Get Customer Groups.
     *
     * @return string
     */
    public function getCustomerGroups()
    {
        return $this->getData(self::CUSTOMER_GROUPS);
    }

    /**
     * Set Customer Groups.
     *
     * @param string $customerGroups
     */
    public function setCustomerGroups($customerGroups)
    {
        return $this->setData(self::CUSTOMER_GROUPS, $customerGroups);
    }

    /**
     * Get Currency.
     *
     * @return string
     */
    public function getCurrency()
    {
        return $this->getData(self::CURRENCY);
    }

    /**
     * Set Currency.
     *
     * @param string $currency
     */
    public function setCurrency($currency)
    {
        return $this->setData(self::CURRENCY, $currency);
    }

    /**
     * Get Carrier.
     *
     * @return string
     */
    public function getCarrier()
    {
        return $this->getData(self::CARRIER);
    }

    /**
     * Set Carrier.
     *
     * @param string $carrier
     */
    public function setCarrier($carrier)
    {
        return $this->setData(self::CARRIER, $carrier);
    }

    /**
     * Get Created At.
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * Set Created At.
     *
     * @param string $createdAt
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * Get Updated At.
     *
     * @return string
     */
    public function getUpdatedAt()
    {
        return $this->getData(self::UPDATED_AT);
    }

    /**
     * Set Updated At.
     *
     * @param string $updatedAt
     */
    public function setUpdatedAt($updatedAt)
    {
        return $this->setData(self::UPDATED_AT, $updatedAt);
    }

    /**
     * Get Status.
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->getData(self::STATUS);
    }

    /**
     * Set Status.
     *
     * @param string $status
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * Get Sort Order.
     *
     * @return int
     */
    public function getSortOrder()
    {
        return $this->getData(self::SORT_ORDER);
    }

    /**
     * Set Sort Order.
     *
     * @param string $sortOrder
     */
    public function setSortOrder($sortOrder)
    {
        return $this->setData(self::SORT_ORDER, $sortOrder);
    }

    /**
     * Get Is Tag Required
     *
     * @return int
     */
    public function getIsTagRequired()
    {
        return $this->getData(self::TAG_REQUIRED);
    }

    /**
     * Set Is Tag Required
     *
     * @param string $isTagRequired
     */
    public function setIsTagRequired($isTagRequired)
    {
        $this->setData(self::TAG_REQUIRED, $isTagRequired);
    }

    /**
     * Get Destination tag memo
     *
     * @return string
     */
    public function getDestinationTagMemo()
    {
        return $this->getData(self::DESTINATION_TAG);
    }

    /**
     * Set Destination tag memo
     *
     * @param string $destinationTagMemo
     */
    public function setDestinationTagMemo($destinationTagMemo)
    {
        $this->setData(self::DESTINATION_TAG, $destinationTagMemo);
    }
}
