<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Model;

/**
 * Pay In Store payment method model
 */
class BitcoinCrypto extends \Magento\Payment\Model\Method\AbstractMethod
{
    public const PAYMENT_METHOD_CRYPTOBITCOIN_CODE = 'bitcoincryptopayment';

    /**
     * Payment method code
     *
     * @var string
     */
    protected $_code = self::PAYMENT_METHOD_CRYPTOBITCOIN_CODE;

    /**
     * Get Payment List Type
     *
     * @return int
     */
    public function getPaymentListingType()
    {
        return $this->getConfigData('payment_listing');
    }

    /**
     * Is mail To admin
     *
     * @return int
     */
    public function isMailToAdminOnConfirmation()
    {
        return $this->getConfigData('mail_to_admin_on_confirmation');
    }

    /**
     * Send Payment Reminder
     *
     * @return int
     */
    public function sendPaymentReminder()
    {
        return $this->getConfigData('send_payment_reminder');
    }

    /**
     * Number Of Reminder
     *
     * @return int
     */
    public function numberOfReminder()
    {
        return $this->getConfigData('number_of_reminder');
    }

    /**
     * Reminder Interval
     *
     * @return int
     */
    public function reminderInterval()
    {
        return $this->getConfigData('reminder_interval');
    }

    /**
     * Cancel Order
     *
     * @return int
     */
    public function cancelOrder()
    {
        return $this->getConfigData('cancel_order');
    }

    /**
     * Cancel OrderTime Period
     *
     * @return int
     */
    public function cancelOrderTimePeriod()
    {
        return $this->getConfigData('cancel_order_time_period');
    }

    /**
     * Is DisplayWallet Address
     *
     * @return int
     */
    public function isDisplayWalletAddressOrCode()
    {
        return $this->getConfigData('is_display_wallet_address_or_code');
    }
}
