<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Helper;

use Magento\Customer\Model\Session;
use Magento\Directory\Model\Currency as CurrencyModel;

/**
 * Webkul BitcoinCryptoPayment Helper Email.
 */
class Email extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * @var \Magento\Framework\Translate\Inline\StateInterface
     */
    protected $_inlineTranslation;

    /**
     * @var \Magento\Framework\Mail\Template\TransportBuilder
     */
    protected $_transportBuilder;

    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $_customerSession;

    /**
     * @var int
     */
    protected $_template;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;

    /**
     *
     * @var \Magento\Framework\Message\ManagerInterface
     */
    protected $_messageManager;

    /**
     * @var \Webkul\BitcoinCryptoPayment\Logger\Logger
     */
    protected $logger;

    /**
     * @var Session
     */
    protected $customerSession;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var CurrencyModel
     */
    protected $currencyModel;

    /**
     * Construct
     *
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation
     * @param \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder
     * @param \Magento\Framework\Message\ManagerInterface $messageManager
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param Session $customerSession
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Webkul\BitcoinCryptoPayment\Logger\Logger $logger
     * @param CurrencyModel $currencyModel
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation,
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        Session $customerSession,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Webkul\BitcoinCryptoPayment\Logger\Logger $logger,
        CurrencyModel $currencyModel
    ) {
        parent::__construct($context);
        $this->_inlineTranslation = $inlineTranslation;
        $this->_transportBuilder = $transportBuilder;
        $this->_customerSession = $customerSession;
        $this->_storeManager = $storeManager;
        $this->_messageManager = $messageManager;
        $this->scopeConfig = $scopeConfig;
        $this->logger = $logger;
        $this->currencyModel = $currencyModel;
    }

    /**
     * Return store.
     *
     * @return Store
     */
    public function getStore()
    {
        return $this->_storeManager->getStore();
    }

    /**
     * Send Email
     *
     * @param mixed $emailTemplateVariables
     * @param array $receiverInfo
     * @param string $template
     *
     * @return void
     */
    public function sendEmail($emailTemplateVariables, $receiverInfo, $template)
    {
        try {
            $adminEmail = $this->scopeConfig->getValue(
                'trans_email/ident_support/email',
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            );
            $adminUsername = $this->scopeConfig->getValue(
                'trans_email/ident_support/name',
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            );
            $senderInfo = ['email' => $adminEmail, 'name' => $adminUsername];
            $templateOptions = ['area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                'store' => $this->getStore()->getId()];
            $this->_inlineTranslation->suspend();
            $templateId = $this->scopeConfig->getValue(
                $template,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                $this->getStore()->getId()
            );

            $transport = $this->_transportBuilder->setTemplateIdentifier(
                $templateId,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE
            )
                ->setTemplateOptions($templateOptions)
                ->setTemplateVars($emailTemplateVariables)
                ->setFrom($senderInfo)
                ->addTo($receiverInfo)
                ->getTransport();
            $transport->sendMessage();
            $this->_inlineTranslation->resume();
        } catch (\Exception $e) {
            $this->logger->info($e->getMessage());
        }
    }

    /**
     * Add Currency Format
     *
     * @param float $amount
     * @param string $currencySymbol
     * @param int $precision
     * @return string
     */
    public function currencyFormat($amount, $currencySymbol, $precision = 2)
    {
        return $this->currencyModel->format($amount, ['symbol' => $currencySymbol, 'precision' => $precision], false);
    }
}
