<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Cron;

use Webkul\BitcoinCryptoPayment\Model\BitcoinCrypto;

class UpdateOrders
{
    /**
     * @var \Magento\Framework\Module\Manager
     */
    protected $moduleManager;

    /**
     * @var BitcoinCrypto
     */
    protected $paymentMethod;

    /**
     * @var \Webkul\BitcoinCryptoPayment\Helper\Data
     */
    protected $cryptoHelper;

    /**
     * Constructor
     *
     * @param \Magento\Framework\Module\Manager $moduleManager
     * @param BitcoinCrypto $paymentMethod
     * @param \Webkul\BitcoinCryptoPayment\Helper\Data $cryptoHelper
     */
    public function __construct(
        \Magento\Framework\Module\Manager $moduleManager,
        BitcoinCrypto $paymentMethod,
        \Webkul\BitcoinCryptoPayment\Helper\Data $cryptoHelper
    ) {
        $this->moduleManager = $moduleManager;
        $this->paymentMethod = $paymentMethod;
        $this->cryptoHelper = $cryptoHelper;
    }

    /**
     * Update BitcoinCrypto Payment Orders
     *
     * @return void
     */
    public function execute()
    {
        if ($this->moduleManager->isEnabled('Webkul_BitcoinCryptoPayment')) {
            if ($this->paymentMethod->sendPaymentReminder()) {
                $this->cryptoHelper->sendReminderEmail();
            }
            if ($this->paymentMethod->cancelOrder()) {
                $this->cryptoHelper->automaticCancelOrder();
            }
        }
    }
}
