<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Controller\Crypto;

use Magento\Framework\Controller\ResultFactory;
use Webkul\BitcoinCryptoPayment\Helper\Data as CryptoHelper;

class AvailablePaymentMethods extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoPaymentConfigProvider
     */
    protected $provider;

    /**
     * @var CryptoHelper
     */
    protected $cryptoHelper;

    /**
     * Constructor
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param CryptoHelper $cryptoHelper
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        CryptoHelper $cryptoHelper
    ) {
        $this->cryptoHelper = $cryptoHelper;
        parent::__construct($context);
    }

    /**
     * Execute function
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $availableCryptoMethods = $this->getAvailableCryptoPaymentMethods();
        $responseContent = [
            'success' => false,
            'availablePaymentMethods' => [],
            'count' => 0,
        ];

        if (count($availableCryptoMethods)) {
            $responseContent = [
                'success' => true,
                'availablePaymentMethods' => $availableCryptoMethods,
                'count' => count($availableCryptoMethods),
            ];
        }

        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        $response->setData($responseContent);
        return $response;
    }

    /**
     * Get available crypto payment methods
     *
     * @return array
     */
    public function getAvailableCryptoPaymentMethods()
    {
        $paymentDetails = $this->cryptoHelper->getCryptoPaymentMethodsForOrder();
        if ($paymentDetails) {
            $totalOrderAmt = (float) $this->cryptoHelper->getCurrentQuote()->getGrandTotal();
            $currencySign = $this->cryptoHelper->getQuoteCurrency();
            foreach ($paymentDetails as $k => &$method) {
                $exchangeRate = $this->cryptoHelper->getExchangeRate(
                    $totalOrderAmt,
                    $currencySign,
                    $method['unit'],
                    $method['decimal_places']
                );
                if ($exchangeRate) {
                    $method['exchaged_amount'] = $exchangeRate;
                } else {
                    unset($paymentDetails[$k]);
                }
            }

            $updatedArray = array_values($paymentDetails);
            return $updatedArray;
        }
        return [];
    }
}
