<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Controller\Adminhtml\Index;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Data\Form\FormKey\Validator;
use Magento\Framework\View\Result\PageFactory;
use Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoPaymentFactory;

class Save extends Action
{
    /**
     * @var PageFactory
     */
    protected $resultPageFactory;

    /**
     * @var BitcoinCryptoPaymentFactory
     */
    protected $bitcoinCryptoPaymentFactory;

    /**
     * @var Validator
     */
    protected $formKeyValidator;

    /**
     * Constructor
     *
     * @param Context $context
     * @param PageFactory $resultPageFactory
     * @param BitcoinCryptoPaymentFactory $bitcoinCryptoPaymentFactory
     * @param Validator $formKeyValidator
     */
    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        BitcoinCryptoPaymentFactory $bitcoinCryptoPaymentFactory,
        Validator $formKeyValidator
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->bitcoinCryptoPaymentFactory = $bitcoinCryptoPaymentFactory;
        $this->formKeyValidator = $formKeyValidator;
        parent::__construct($context);
    }

    /**
     * Execute function
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        $resultPageFactory = $this->resultRedirectFactory->create();
        if (!$this->formKeyValidator->validate($this->getRequest())) {
            $this->messageManager->addErrorMessage(__("Form key is Invalidate"));
            return $resultPageFactory->setPath('*/*/index');
        }
        $data = $this->getRequest()->getPostValue();

        try {
            if ($data) {
                $model = $this->bitcoinCryptoPaymentFactory->create();
                if (isset($data['entity_id']) && $data['entity_id'] != '') {
                    $model->load($data['entity_id']);
                    $model->setUpdatedAt(date("Y-m-d h:i:sa"));
                } else {
                    $bitcoinpayModel = $this->bitcoinCryptoPaymentFactory->create();
                    $name = $bitcoinpayModel->load($data['name'], 'name');

                    if ($name->getEntityId() != '') {
                        $this->messageManager->addErrorMessage(__("Wallet Name already exists."));
                        return $resultPageFactory->setPath('*/*/new');
                    }

                    $unit = $bitcoinpayModel->load($data['unit'], 'unit');
                    if ($unit->getEntityId() != '') {
                        $this->messageManager->addErrorMessage(__("Wallet Unit already exists."));
                        return $resultPageFactory->setPath('*/*/new');
                    }

                    $address = $bitcoinpayModel->load($data['address'], 'address');
                    if ($address->getEntityId() != '') {
                        $this->messageManager->addErrorMessage(__("Wallet Address already exists."));
                        return $resultPageFactory->setPath('*/*/new');
                    }

                    $tag = $bitcoinpayModel->load($data['destination_tag_memo'], 'destination_tag_memo');
                    if ($tag->getEntityId() != '') {
                        $this->messageManager->addErrorMessage(__("Destination Tag/Memo already exists."));
                        return $resultPageFactory->setPath('*/*/new');
                    }
                    $model->setCreatedAt(date("Y-m-d h:i:sa"));
                }
                $model->setName($data['name'] ?? '');
                $model->setUnit($data['unit'] ?? '');
                $model->setAddress($data['address'] ?? '');
                $model->setDecimalPlaces($data['decimal_places'] ?? '');
                $model->setSortOrder($data['data']['sort_order'] ?? '');
                $model->setCustomerGroups(isset($data['data']['customer_groups'])
                    ? implode(',', $data['data']['customer_groups']) : '');
                $model->setCurrency(isset($data['data']['currency'])
                    ? implode(',', $data['data']['currency']) : '');
                $model->setCarrier(isset($data['data']['carrier'])
                    ? implode(',', $data['data']['carrier']) : '');
                $model->setStatus($data['status'] ?? '');
                $model->setIsTagRequired($data['is_tag_required'] ?? 0);
                $model->setDestinationTagMemo($data['destination_tag_memo'] ?? '');
                $model->save();
                $this->messageManager->addSuccessMessage(__("Data Saved Successfully."));
                $buttondata = $this->getRequest()->getParam('back');
                if ($buttondata == 'add') {
                    return $resultPageFactory->setPath('*/*/index');
                }
                if ($buttondata == 'close') {
                    return $resultPageFactory->setPath('*/*/index');
                }
                $id = $model->getId();
                return $resultPageFactory->setPath('*/*/edit', ['entity_id' => $id]);
            }
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e, __("We can't submit your request, Please try again."));
        }
        return $resultPageFactory->setPath('*/*/index');
    }
}
