<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Controller\Adminhtml\Index;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;

class Delete extends Action
{
    public const ADMIN_RESOURCE = 'Webkul_BitcoinCryptoPayment::delete';

    /**
     * @var \Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoPayment
     */
    protected $bitcoinCryptoPayment;

    /**
     * Constructor
     *
     * @param Context $context
     * @param \Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoPayment $bitcoinCryptoPayment
     */
    public function __construct(
        Context $context,
        \Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoPayment $bitcoinCryptoPayment
    ) {
        parent::__construct($context);
        $this->bitcoinCryptoPayment = $bitcoinCryptoPayment;
    }

    /**
     * Delete action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $id = $this->getRequest()->getParam('entity_id');
        /** @var \Magento\Backend\Model\View\Result\Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        if ($id) {
            try {
                $model = $this->bitcoinCryptoPayment;
                $model->load($id);
                $model->delete();
                $this->messageManager->addSuccess(__('Record deleted successfully.'));
                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addError($e->getMessage());
                return $resultRedirect->setPath('*/*/edit', ['id' => $id]);
            }
        }
        $this->messageManager->addError(__('Record does not exist.'));
        return $resultRedirect->setPath('*/*/');
    }
}
