<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Block;

/**
 * Base payment information block
 *
 * @api
 * @since 100.0.2
 */
class Info extends \Magento\Payment\Block\Info
{
    /**
     * @var string
     */
    protected $_template = 'Webkul_BitcoinCryptoPayment::info/default.phtml';

    /**
     * @var \Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoPayment
     */
    public $bitcoinCryptoPayment;

    /**
     * Info class constructor
     *
     * @param \Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoPayment $bitcoinCryptoPayment
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param array $data
     */
    public function __construct(
        \Webkul\BitcoinCryptoPayment\Model\BitcoinCryptoPayment $bitcoinCryptoPayment,
        \Magento\Framework\View\Element\Template\Context $context,
        array $data = []
    ) {
        $this->bitcoinCryptoPayment = $bitcoinCryptoPayment;
        parent::__construct($context, $data);
    }

    /**
     * Render as PDF
     *
     * @return string
     */
    public function toPdf()
    {
        $this->setTemplate('Webkul_BitcoinCryptoPayment::info/pdf/default.phtml');
        return $this->toHtml();
    }

    /**
     * Get Payment Method Name
     *
     * @param int $orderCryptoId
     *
     * @return string
     */
    public function getPaymentMethodName($orderCryptoId)
    {
        if ($orderCryptoId) {
            $cryptoPay = $this->bitcoinCryptoPayment->load($orderCryptoId);
            return $this->getMethod()->getConfigData('title') . ' (' . $cryptoPay->getName() . ')';
        }
        return $this->getMethod()->getConfigData('title', $this->getInfo()->getOrder()->getStoreId());
    }
}
