<?php

/**
 * Webkul Software
 *
 * @category  Webkul
 * @package   Webkul_BitcoinCryptoPayment
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */

namespace Webkul\BitcoinCryptoPayment\Api\Data;

interface BitcoinCryptoPaymentInterface
{
    /**
     * Constants for keys of data array. Identical to the name of the getter in snake case.
     */
    public const ENTITY_ID = 'entity_id';
    public const NAME = 'name';
    public const UNIT = 'unit';
    public const ADDRESS = 'address';
    public const DECIMAL_PLACES = 'decimal_places';
    public const CUSTOMER_GROUPS = 'customer_groups';
    public const CURRENCY = 'currency';
    public const CARRIER = 'carrier';
    public const CREATED_AT = 'created_at';
    public const UPDATED_AT = 'updated_at';
    public const STATUS = 'status';
    public const SORT_ORDER = 'sort_order';
    public const TAG_REQUIRED = 'is_tag_required';
    public const DESTINATION_TAG = 'destination_tag_memo';

    /**
     * Get EntityId.
     *
     * @return int
     */
    public function getEntityId();

    /**
     * Set EntityId.
     *
     * @param int $entityId
     */
    public function setEntityId($entityId);

    /**
     * Get Name.
     *
     * @return string
     */
    public function getName();

    /**
     * Set Name.
     *
     * @param string $name
     */
    public function setName($name);

    /**
     * Get Unit.
     *
     * @return string
     */
    public function getUnit();

    /**
     * Set Unit.
     *
     * @param string $unit
     */
    public function setUnit($unit);

    /**
     * Get Address.
     *
     * @return string
     */
    public function getAddress();

    /**
     * Set Address.
     *
     * @param string $address
     */
    public function setAddress($address);

    /**
     * Get Decimal Places.
     *
     * @return int
     */
    public function getDecimalPlaces();

    /**
     * Set Decimal Places.
     *
     * @param int $decimalPlaces
     */
    public function setDecimalPlaces($decimalPlaces);

    /**
     * Get Customer Groups.
     *
     * @return string
     */
    public function getCustomerGroups();

    /**
     * Set Customer Groups.
     *
     * @param string $customerGroups
     */
    public function setCustomerGroups($customerGroups);

    /**
     * Get Currency.
     *
     * @return string
     */
    public function getCurrency();

    /**
     * Set Currency.
     *
     * @param string $currency
     */
    public function setCurrency($currency);

    /**
     * Get Carrier.
     *
     * @return string
     */
    public function getCarrier();

    /**
     * Set Carrier.
     *
     * @param string $carrier
     */
    public function setCarrier($carrier);

    /**
     * Get Created At.
     *
     * @return string
     */
    public function getCreatedAt();

    /**
     * Set Created At.
     *
     * @param string $createdAt
     */
    public function setCreatedAt($createdAt);

    /**
     * Get Updated At.
     *
     * @return string
     */
    public function getUpdatedAt();

    /**
     * Set Updated At.
     *
     * @param string $updatedAt
     */
    public function setUpdatedAt($updatedAt);

    /**
     * Get Status.
     *
     * @return string
     */
    public function getStatus();

    /**
     * Set Status.
     *
     * @param string $status
     */
    public function setStatus($status);

    /**
     * Get Sort Order.
     *
     * @return int
     */
    public function getSortOrder();

    /**
     * Set Sort Order.
     *
     * @param int $sortOrder
     */
    public function setSortOrder($sortOrder);

    /**
     * Get Is Tag Required
     *
     * @return string
     */
    public function getIsTagRequired();

    /**
     * Set Is Tag Required
     *
     * @param string $isTagRequired
     */
    public function setIsTagRequired($isTagRequired);

    /**
     * Get Destination tag memo
     *
     * @return string
     */
    public function getDestinationTagMemo();

    /**
     * Set Destination tag memo
     *
     * @param string $destinationTagMemo
     */
    public function setDestinationTagMemo($destinationTagMemo);
}
