<?php
namespace Custom\CustomerFields\Setup\Patch\Data;

use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Customer\Setup\CustomerSetupFactory;

class AddCustomerAttributes implements DataPatchInterface
{
    private $moduleDataSetup;
    private $customerSetupFactory;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        CustomerSetupFactory $customerSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->customerSetupFactory = $customerSetupFactory;
    }

    public function apply()
    {
        $this->moduleDataSetup->getConnection()->startSetup();
        $customerSetup = $this->customerSetupFactory->create(['setup' => $this->moduleDataSetup]);

        $attributes = [
            'bucque' => 'Bucque',
            'promo' => 'Promo'
        ];

        foreach ($attributes as $code => $label) {
            $customerSetup->addAttribute(
                \Magento\Customer\Model\Customer::ENTITY,
                $code,
                [
                    'type' => 'varchar',
                    'label' => $label,
                    'input' => 'text',
                    'required' => false,
                    'visible' => true,
                    'user_defined' => true,
                    'system' => 0,
                    'position' => 999
                ]
            );

            $attribute = $customerSetup->getEavConfig()->getAttribute('customer', $code);
            $attribute->setData('used_in_forms', [
                'customer_account_create', 'customer_account_edit', 'adminhtml_customer'
            ]);
            $attribute->save();
        }

        $this->moduleDataSetup->getConnection()->endSetup();
    }

    public static function getDependencies() { return []; }

    public function getAliases() { return []; }
}
