<?php
namespace Custom\CustomerFields\Plugin;

use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Customer\Controller\Account\CreatePost;
use Magento\Framework\App\RequestInterface;

class AddCustomFieldsPlugin
{
    protected $request;
    protected $customerRepository;

    public function __construct(
        RequestInterface $request,
        CustomerRepositoryInterface $customerRepository
    ) {
        $this->request = $request;
        $this->customerRepository = $customerRepository;
    }

    public function afterExecute(CreatePost $subject, $result)
    {
        $customer = $subject->getSession()->getCustomer();
        if (!$customer || !$customer->getId()) {
            return $result;
        }

        $params = $this->request->getParams();

        try {
            if (isset($params['bucque'])) {
                $customer->setCustomAttribute('bucque', $params['bucque']);
            }

            if (isset($params['promo'])) {
                $customer->setCustomAttribute('promo', $params['promo']);
            }

            $this->customerRepository->save($customer);
        } catch (\Exception $e) {
            // You can log if needed
        }

        return $result;
    }
}
