<?php
namespace Custom\CustomerFields\Observer;

use Magento\Framework\App\RequestInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Framework\Exception\LocalizedException;

class SaveCustomFields implements \Magento\Framework\App\Action\HttpPostActionInterface
{
    protected $request;
    protected $customerRepository;

    public function __construct(
        RequestInterface $request,
        CustomerRepositoryInterface $customerRepository
    ) {
        $this->request = $request;
        $this->customerRepository = $customerRepository;
    }

    public function execute(\Magento\Framework\App\ActionInterface $subject)
    {
        $customer = $subject->getResultRedirect()->getData('customer');
        if (!$customer) return;

        $data = $this->request->getPostValue();

        try {
            if (!empty($data['bucque'])) {
                $customer->setCustomAttribute('bucque', $data['bucque']);
            }

            if (!empty($data['promo'])) {
                $customer->setCustomAttribute('promo', $data['promo']);
            }

            $this->customerRepository->save($customer);
        } catch (LocalizedException $e) {
            // Handle error
        }
    }
}
