<?php

namespace Capdeal\Ads\Block;

use Magento\Framework\View\Element\Template;
use Magento\Catalog\Model\ResourceModel\Category\CollectionFactory as CategoryCollectionFactory;
use Magento\Customer\Model\Session;
use Magento\Framework\App\Response\RedirectInterface;

class Form extends Template
{
    protected $categoryCollectionFactory;
    protected $customerSession;
    protected $redirect;

    public function __construct(
        Template\Context $context,
        CategoryCollectionFactory $categoryCollectionFactory,
        Session $customerSession,
        RedirectInterface $redirect,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->categoryCollectionFactory = $categoryCollectionFactory;
        $this->customerSession = $customerSession;
        $this->redirect = $redirect;
    }

    protected function _prepareLayout()
    {
        // Redirect non-logged-in users to the login page
        // if (!$this->customerSession->isLoggedIn()) {
        //     $loginUrl = $this->getUrl('customer/account/login');
        //     header('Location: ' . $loginUrl);
        //     exit;
        // }
        return parent::_prepareLayout();
    }

    public function getCategories()
    {
        return $this->categoryCollectionFactory->create()
            ->addAttributeToSelect('*')
            ->setOrder('name', 'ASC');
    }
}
